* Title: 	figure6.do
* Version: 	23 May 2018
* Purpose: 	Produce graph of trends in joblessness


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/figures/log/figure6, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use year statefip PrimeMaleD UnempB LTJoblessB wtsupp ///
	using dta/asec_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only continental 48 states (excluding District of Columbia)
drop if (statefip == 02 | statefip == 11 | statefip == 15 | statefip>56)


*******************************************************************************
* (2) Construct rates for joblessness categories
*******************************************************************************

collapse (sum) Total = PrimeMaleD PMJobless = UnempB LTJobless = LTJoblessB ///
		 [pw=wtsupp], by(year)

tsset year
foreach var of varlist PMJobless LTJobless {
	gen `var'_Rate = 100 * (L.`var' + `var' + F.`var') / (L.Total + Total + F.Total)
}

keep year *_Rate 
keep if (year >= 1978 & year <= 2015)

* Save dataset
compress
save output/figures/dta/figure6.dta, replace


*******************************************************************************
* (3) Produce graph
*******************************************************************************

line 	PMJobless_Rate LTJobless_Rate year, ///
		legend(label(1 "Total Not Working Rate") label(2 ">12 months Not Working Rate") size(small)) ///
		graphregion(color(white)) bgcolor(white) ///
		xtitle("Year") ytitle("Not Working rate, percent")

graph save output/figures/gph/figure6, replace
graph export output/figures/eps/figure6.eps, as(eps) replace
export excel using output/figures/xlsx/figure6.xlsx, first(variables) replace


*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
